/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.base;

import filenet.vw.integrator.IVWAdaptorControl;
import filenet.vw.integrator.IVWComponentManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.rmi.UnmarshalException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class TVWComponentManager {
    protected static String regname = "FileNET.VW.VWComponentManager";

    protected static void printHelp() {
        System.out.println();
        System.out.println("?, help = help");
        System.out.println("quit = quit");
        System.out.println("stop = force component manager to shutdown");
        System.out.println("listall = list all adaptors");
        System.out.println("startall = start all");
        System.out.println("stopall = stop all");
        System.out.println("refreshall = stop and refresh all adaptors");
        System.out.println("start <adaptor_name> = start an adaptor");
        System.out.println("stop <adaptor_name> = stop an adaptor");
        System.out.println("refresh <adaptor_name> = refresh an adaptor");
        System.out.println("getinfo <adaptor_name> = get info for the specified adaptor");
        System.out.println("resetstats <adaptor_name> = reset call stats for the specified adaptor");
        System.out.println("threads = display info about current threads");
        System.out.println();
    }

    protected static Registry getRegistry() throws Exception {
        Registry reg = null;
        try {
            try {
                reg = LocateRegistry.createRegistry(1099);
            }
            catch (Exception e) {
                reg = LocateRegistry.getRegistry(1099);
            }
            if (reg == null) {
                try {
                    reg = LocateRegistry.createRegistry(32771);
                }
                catch (Exception e) {
                    reg = LocateRegistry.getRegistry(32771);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (reg == null) {
            throw new Exception("Unable to start Component Manager");
        }
        return reg;
    }

    public static void main(String[] args) {
        try {
            Registry reg = TVWComponentManager.getRegistry();
            IVWComponentManager smi = (IVWComponentManager)reg.lookup(regname);
            if (smi == null) {
                System.out.println("No Component Manager available.");
                System.out.println();
            } else {
                System.out.println("Component Manager available: " + smi);
                System.out.println();
            }
            boolean done = false;
            TVWComponentManager.printHelp();
            while (!done) {
                String adaptorname;
                System.out.print(">");
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                String cmd = br.readLine();
                if (cmd.equals("quit")) {
                    done = true;
                } else if (cmd.equals("stop")) {
                    if (smi != null) {
                        smi.stop();
                    }
                    done = true;
                } else if (cmd.equals("?")) {
                    TVWComponentManager.printHelp();
                } else if (cmd.equals("help")) {
                    TVWComponentManager.printHelp();
                } else if (cmd.equals("listall")) {
                    if (smi != null) {
                        String[] adaptors = smi.getAdaptorNames();
                        for (int i = 0; adaptors != null && i < adaptors.length; ++i) {
                            IVWAdaptorControl ac = smi.getAdaptorControl(adaptors[i]);
                            if (ac.adaptorIsStarted()) {
                                System.out.println("\t" + adaptors[i] + "\tstarted");
                                continue;
                            }
                            System.out.println("\t" + adaptors[i] + "\tstopped");
                        }
                    }
                } else if (cmd.equals("startall")) {
                    if (smi != null) {
                        smi.startAllAdaptors();
                    }
                } else if (cmd.equals("stopall")) {
                    if (smi != null) {
                        smi.stopAllAdaptors();
                    }
                } else if (cmd.equals("refreshall")) {
                    if (smi != null) {
                        smi.refreshAllAdaptors();
                    }
                } else if (cmd.startsWith("start ")) {
                    adaptorname = cmd.substring(6);
                    adaptorname = adaptorname.trim();
                    if (smi != null) {
                        smi.startAdaptor(adaptorname);
                    }
                } else if (cmd.startsWith("stop ")) {
                    adaptorname = cmd.substring(5);
                    adaptorname = adaptorname.trim();
                    if (smi != null) {
                        smi.stopAdaptor(adaptorname);
                    }
                } else if (cmd.startsWith("refresh ")) {
                    adaptorname = cmd.substring(8);
                    adaptorname = adaptorname.trim();
                    if (smi != null) {
                        smi.refreshAdaptor(adaptorname);
                    }
                } else if (cmd.startsWith("getinfo ")) {
                    adaptorname = cmd.substring(8);
                    adaptorname = adaptorname.trim();
                    IVWAdaptorControl ac = smi.getAdaptorControl(adaptorname);
                    System.out.println("\tName:\t\t\t\t" + ac.getName());
                    System.out.println("\tSvc Desc:\t\t\t" + ac.getComponentDescriptor());
                    System.out.println("\tStart Time:\t\t" + ac.getLastStartTime());
                    System.out.println("\tStop TIme:\t\t" + ac.getLastStopTime());
                    System.out.println("\tStarted:\t\t\t" + ac.adaptorIsStarted());
                    System.out.println("\tCalls/Min:\t\t" + ac.getAverageCallsPerMinute());
                    System.out.println("\tAvg. Call Time:\t" + ac.getAverageCallTimeMillis());
                } else if (cmd.equals("threads")) {
                    ThreadGroup tg = Thread.currentThread().getThreadGroup();
                    Thread[] threads = new Thread[tg.activeCount() * 2];
                    int thread_count = tg.enumerate(threads);
                    System.out.println("\tThreadGroup:  " + tg + " has " + thread_count + " running threads.");
                    for (int i = 0; i < thread_count; ++i) {
                        System.out.println("\t\t" + threads[i]);
                    }
                } else if (cmd.startsWith("resetstats ")) {
                    adaptorname = cmd.substring(11);
                    adaptorname = adaptorname.trim();
                    if (smi != null) {
                        smi.resetCallTimeStatistics(adaptorname);
                    }
                } else {
                    TVWComponentManager.printHelp();
                }
                System.out.println();
            }
            System.exit(1);
        }
        catch (UnmarshalException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

